using System;
using System.Xml;
using System.Reflection;
using System.Collections;
using System.Diagnostics;

namespace Team_Project.PersistencyManagers.Storages
{
	/// <summary>
	/// Gestisce l'associazione tra gli storages, i progetti e i tipi di elementi
	/// </summary>
	public class StorageManager
	{
		private string configPath;
		private bool useProjectName;

		/// <summary>
		/// Costruisce uno storage manager. Il file di configurazione utilizzato
		///  "storages.xml" sotto "Config\Storages"
		/// </summary>
		public StorageManager():
#if DEBUG
			this(@"..\..\..\Config\Storages\Storages.xml",false)
#else
			this(@"Config\Storages\Storages.xml",false)
#endif
		{}

		/// <summary>
		/// Crea uno storage manager che utilizza il file di configurazione indicato
		/// dai parametri.
		/// </summary>
		/// <param name="configPath">Percorso dove  localizzato il file di configurazione.
		/// Se il parametro <b>useProjectAsFileName</b>  true questo parametro deve
		/// contenere solo il percorso del file, come nome verr utilizzato il nome del
		/// progetto; altrimenti questo parametro deve contenere il percorso compreso di
		/// nome del file (assoluto o relativo)</param>
		/// <param name="useProjectAsFileName">true se si desidera utilizzare un file
		/// per ogni progetto, false per utilizzare lo stesso file per tutti i progetti</param>
		public StorageManager(string configPath,bool useProjectAsFileName)
		{
			useProjectName = useProjectAsFileName;
			if(useProjectName && configPath!= string.Empty && !configPath.EndsWith(@"\"))
				this.configPath = configPath + @"\";
			else
				this.configPath = configPath;
		}

		private static Hashtable Storages = new Hashtable();
		
		/// <summary>
		/// Restituisce lo storage associato ad un certo tipo di elemento
		/// per un certo progetto
		/// </summary>
		/// <param name="projName">Nome del progetto</param>
		/// <param name="elementType">Tipo dell'elemento</param>
		/// <returns>Storage da utilizzare per accedere agli elementi</returns>
		public IStorage GetStorageFor(string projName,Type elementType)
		{
			lock(Storages)
			{
				if(!Storages.ContainsKey(projName))
				{
					XmlDocument config = new XmlDocument();
					if(!useProjectName)
						config.Load(configPath);
					else
						config.Load(configPath + projName + ".xml");

					string xpath = "//Storages/Project[@name=\""+ projName+"\"]/Element[@name=\""
						+elementType.Name+"\"]/Storage";
					Trace.WriteLine("GetStorageFor.XPath: " + xpath);
				
					XmlNode lclCfg = config.SelectSingleNode(xpath);
					Assembly a = Assembly.Load(lclCfg.Attributes["assembly"].Value);
					Type t = a.GetType(lclCfg.Attributes["type"].Value);
					Storages.Add(projName,(IStorage)Activator.CreateInstance(t, new object[]{lclCfg}));
				}
				return (IStorage)Storages[projName];
			}
		}
	}
}
